

/* Pocket Smalltalk
   Copyright (c) 1998,1999 by Andrew Brault
   http://www.pocketsmalltalk.com
   See LICENSE.TXT for license information */

/* Values known to the virtual machine, and
   external VM functions and registers. */


/* Objects with fixed object table slots.
   These definitions give the objref values for
   objects known to the virtual machine.
*/
#define nil 			0
#define true_obj                2
#define false_obj               4
#define SmallInteger		6
#define BlockClosure		8
#define FullBlockClosure        10
#define Message                 12
#define Array                   14
#define ByteArray               16
#define String                  18
#define IdentityDictionary      20
#define Smalltalk               22
#define Character               24
#define LongInteger             26
#define Double			28
#define CPointer                30
#define Process                 32
#define Semaphore               34


/* Failure_value is a reserved objref that indicates
   a primitive failure. */
#define Failure_value           0xFFFEU


/* Selectors known to the virtual machine. */
#define Selector_basicStart         1
#define Selector_not		    2
#define Selector_plus               3
#define Selector_minus              4
#define Selector_lesseq		    5
#define Selector_greatereq	    6
#define Selector_less		    7
#define Selector_greater      	    8
#define Selector_doesNotUnderstand  9
#define Selector_basicAt            10
#define Selector_basicAtPut         11
#define Selector_mustBeBoolean      12
#define Selector_contextAlreadyReturned	13
#define Selector_badTrapArgument    14


/* Fields of instances of BlockClosure and FullBlockClosure.
   BlockClosure has the first 3.
   FullBlockClosure has all 5.
*/
#define Block_ownerClass	0
#define Block_offset		1
#define Block_argumentCount     2
#define Block_nextOuter		3
#define Block_nextLink		4


/* Instance variables of Behavior and Metaclass */
#define Behavior_superclass        0
#define Behavior_layout            1
#define Metaclass_uniqueInstance   2


/* Instance variables of Message */
#define Message_selector       0
#define Message_arguments      1


/* Instance variables of Process */
#define Process_next	   	    0
#define Process_priority      	    1
#define Process_status              2
#define Process_semaphore	    3


/* Instance variables of Semaphore */
#define Semaphore_first		    0
#define Semaphore_last		    1
#define Semaphore_signals           2



#ifdef PROFILING
extern unsigned long instructions_executed;
extern unsigned long garbage_collections;

#ifdef METHOD_CACHE
extern unsigned long cache_hits;
extern unsigned long cache_misses;
#endif

#endif



/* External VM registers */

typedef struct {
  Object receiver;
  uint16 local_var_base;
  uint16 data_stack_ptr;
  uint8 * instruction_ptr;
  Object closure_chain;
} StackFrame;

extern Object * data_stack;
extern uint16 data_stack_ptr;
extern Object receiver;
extern StackFrame * call_stack;
extern uint16 call_stack_ptr;



/* Utility macros */

/* Convert C boolean to Smalltalk boolean */
#define AS_BOOLEAN(n)  ((n) ? true_obj : false_obj)


/* Functions in vm.c */

void initialize_vm(void);
void run_vm(void);
void save_call_frame(void);
void restore_call_frame(void);
boolean class_implements(Object search_class, uint16 selector);
uint16 infer_selector(Object m_class, uint8 * ip);

void destructure_array(void);
void perform(uint16 arg_count);
boolean block_value(uint16 arg_count);
void init_trap_dispatcher(void);

